<?php
/* --------------------------------------------------------------
 Verifier.php 2020-04-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Layout\Menu\Factories\Helper;

use Gambio\Core\Application\ValueObjects\UserPreferences;
use Gambio\Core\Permission\Model\PermissionDefinition;
use Gambio\Core\Permission\PermissionRepository;

/**
 * Class Verifier
 * @package Gambio\Admin\Layout\Menu\Permissions
 */
class Verifier
{
    /**
     * @var PermissionRepository
     */
    private $permissionRepository;
    
    /**
     * @var Utility
     */
    private $utility;
    
    /**
     * @var UserPreferences
     */
    private $userPreferences;
    
    
    /**
     * Verifier constructor.
     *
     * @param PermissionRepository $permissionRepository
     * @param Utility              $utility
     * @param UserPreferences      $userPreferences
     */
    public function __construct(
        PermissionRepository $permissionRepository,
        Utility $utility,
        UserPreferences $userPreferences
    ) {
        $this->permissionRepository = $permissionRepository;
        $this->utility              = $utility;
        $this->userPreferences      = $userPreferences;
    }
    
    
    /**
     * Checks if a user is allowed to see a menu item.
     *
     * @param string $url
     *
     * @return bool
     */
    public function isAllowed(string $url): bool
    {
        $type       = $this->utility->determineType($url);
        $identifier = $this->utility->determineIdentifier($url);
        
        $definition = PermissionDefinition::create($identifier, $type, 'read');
        $permission = $this->permissionRepository->getPermission($this->userPreferences, $definition);
        
        return $permission->isGranted();
    }
}